package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.SupplierProductDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by zhengjy on 2016/09/05
 */
public interface RemoteSupplierProductsService {
	public DubboResult<SupplierProductDto> findBySupplier(String supplier);
	
	public DubboResult<List<SupplierProductDto>> findAllBySupplier(String supplier);
	
	public DubboResult<SupplierProductDto> findBySupplierAndProductId(String supplier,String productId);
	
	public DubboResult<List<SupplierProductDto>> findBySupplierAndFacePrice(String supplier,Integer facePrice);
	
	public DubboResult<List<SupplierProductDto>> findBySupplierAndMobileAndProvince(String supplier,String mobile,String province);
	
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByNameAndFacePrice(String supplier);
	
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByProvinceAndFacePrice(String supplier);
	
	public DubboResult<List<SupplierProductDto>> findAllBySupplierAndGameId(String supplier,String gameId);
	
	public DubboResult<List<SupplierProductDto>> findAllByIds(List<Long> ids);
	
	public void insert(SupplierProductDto supplierProductDO);
	
	public void update(SupplierProductDto supplierProductDO);
	
	public DubboResult<SupplierProductDto> find(Long id);
}
