/**
 * Project Name:developer-center-api
 * File Name:RemoteAppPushTaskService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice
 * Date:2016年11月2日下午10:01:35
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice.schedule;

import java.util.Date;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AppPushTaskDto;
import cn.com.duiba.developer.center.api.domain.enums.AppPushStatusEnum;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * app计划任务推送服务dubbo接口 <br/>
 * Date:     2016年11月2日 下午10:01:35 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAppPushTaskService {

    /**
     * 查询待执行的app推送任务</br>
     * 查询条件：push_time <= now() and status = 'TO_EXEC'
     *
     * @author zhanglihui
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppPushTaskDto>> queryAppPushTaskToExec();
    
    /**
     * 
     * 更新计划任务状态
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param status        要更新的状态 {@link AppPushStatusEnum}
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> updateAppPushTaskStatus(long appPushTaskId, String status);
    
    /**
     * 更新计划任务执行时间
     *
     * @author zhanglihui
     * @param appPushTaskId 任务主键
     * @param pushTime      执行时间
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> updateAppPushTaskTime(long appPushTaskId, Date pushTime);

    /**
     * 查询可编辑的app推送任务</br>
     * 查询条件： status = 'INIT'
     *
     * @author yaocheng
     * @return List<AppPushTaskDto>
     * @since JDK 1.6
     */
    DubboResult<List<AppPushTaskDto>> queryAppPushTaskForEdit();

    /**
     * 创建或编辑计划任务
     * @param appPushTasks
     * @return Boolean
     */
    DubboResult<Boolean> create(List<AppPushTaskDto> appPushTasks);

    /**
     * 立即执行计划任务
     * @param id
     * @return
     */
    DubboResult<Boolean> executeRightNow(Long duibaTaskId);

    /**
     * 删除计划任务
     * @param duibaTaskId
     * @return
     */
    DubboResult<Boolean> delete(Long duibaTaskId);
    /**
     *	计划任务列表查询
     * @param pageIndex
     * @param pageSize
     * @param appPushTaskDto
     * @return
     */
    DubboResult<PaginationVO<AppPushTaskDto>> findScheduledTaskList(int pageIndex,int pageSize,AppPushTaskDto appPushTaskDto);
    /**
     * 计划任务下app列表查询
     * @param pageIndex
     * @param pageSize
     * @param pushTaskId
     * @return
     */
    DubboResult<PaginationVO<AppPushTaskDto>> findScheduledTaskAppList(int pageIndex,int pageSize,Long pushTaskId);
    
    /**
     * 开启计划任务，并且将tb_credits_app_push_task状态置为待执行（TO_EXEC）
     *
     * @param duibaTaskId 兑吧计划任务ID
     *
     */
    DubboResult<Void> openPushTask(Long duibaTaskId);
 
    /**
     * 关闭计划任务，并且将tb_credits_app_push_task状态置为初始化（INIT）
     *
     * @param duibaTaskId 兑吧计划任务ID
     *
     */
    DubboResult<Void> closePushTask(Long duibaTaskId);
}

