/**
 * Project Name:developer-center-api File Name:CouponFloorConfKeyEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums.floor Date:2016年8月22日下午1:50:55 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums.floor;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.developer.center.api.domain.enums.EnumInterface;

/**
 * ClassName:CouponFloorConfKeyEnum <br/>
 * 优惠券子页面楼层配置项枚举. <br/>
 * Date: 2016年8月22日 下午1:50:55 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum CouponFloorConfKeyEnum implements EnumInterface {
    /** 楼层标题 */
    FLOOR_TITLE("floorTitle", "楼层标题"),

    /** 点击后跳转目标 {@see ChildPageTargetEnum} */
    TARGET("target", "点击后跳转目标"),

    /** 展示数量 */
    SHOW_NUM("showNum", "展示数量");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private CouponFloorConfKeyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponFloorConfKeyEnum getByCode(String code) {
        for (CouponFloorConfKeyEnum enumVal : CouponFloorConfKeyEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
