package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AmbExpressTemplateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

public interface RemoteExpressTemplateService {
	 /**
     * 根据id查询
     * 
     * @param id
     * @return
     */
    public DubboResult<AmbExpressTemplateDto> find(Long id);

    /**
     * 新增记录
     * 
     * @param entity
     * @return
     */
    public DubboResult<Boolean> insert(AmbExpressTemplateDto entity);

    /**
     * 更新记录
     * 
     * @param entity
     */
    public DubboResult<Integer> update(AmbExpressTemplateDto entity);
    
    public DubboResult<List<AmbExpressTemplateDto>> findPageList(Map<String, Object> params);

    public DubboResult<Long> findPageCount(Map<String, Object> params);
    
    public DubboResult<Boolean> deleteTemplateById(Long id);

    /**
     * @param appId
     * @param type
     */
    public DubboResult<List<AmbExpressTemplateDto>> findByAppIdAndType(Long appId, String type);

    /**
     * @param appId
     * @param name
     */
    public DubboResult<AmbExpressTemplateDto> findByAppIdAndName(Long appId, String name);
}
