package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.AppLayoutBrickDto;
import cn.com.duiba.developer.center.api.domain.dto.AppLayoutDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONArray;

/**
 * Created by liuyao on 16/7/27.
 */
public interface RemoteAppLayoutService {

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getSystemLayoutPage(PageQueryEntity params);

    public DubboResult<PaginationVO<AppLayoutBrickDto>> getCustomLayoutPage(PageQueryEntity params);

    /**
     * 开发者更新主题色
     * @param appId
     * @param color
     * @return
     */
    public DubboResult<Boolean> updateThemeColor(Long appId,String color);

    /**
     * 开发选择使用楼层皮肤
     * @return
     */
    public DubboResult<Boolean> devSetSkin(Long appId, Long skinId);

    /**
     * [{id:楼层Id,floorType:楼层类型,enable:是否展示}]
     * @param appId
     * @param floorSortList
     * @return
     */
    public DubboResult<Boolean> devReSetFloorList(Long appId,JSONArray floorSortList);
    /**
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @author zhanglihui
     * @param appId       app主键
     * @param floorId     楼层ID
     * @param floorConfig 楼层配置，楼层配置，配置项key值参见相应枚举对象 （ActivityFloorConfKeyEnum，CouponFloorConfKeyEnum， SnapUpFloorConfKeyEnum ...）
     * @return 
     * @since JDK 1.6
     */
    DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long floorId, Map<String, Object> floorConfig);

    /**
     * 高并发调用接口
     * @param appId
     * @return
     */
    public DubboResult<AppLayoutDto> getAppLayout(Long appId);

    /**
     * 获取皮肤类型(手机端高并发调用)
     * @param appId
     * @return
     */
    public DubboResult<Integer> getSkinType(Long appId);
}
