package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.developer.center.api.domain.dto.RecommendBlacklistDto;

public interface RemoteDuibaRecommendQueueBlacklistService {

	/**
	 * 保存推荐位黑名单
	 * @param list 页面批量传过来的黑名单的数据
	 */
	public void saveRecommendQueueBlacklist(List<Map<String, Object>> list);
	
	/**
	 * 删除推荐位黑名单
	 * @param appId 应用ID
	 */
	public void deleteRecommendQueueBlacklist(Long appId);
	
	/**
	 * 编辑黑名单
	 * @param appId 应用ID
	 * @param duibaActivity 兑吧活动
	 * @param ownActivity 自有活动
	 * @param goods 商品(兑换项)
	 */
	public void updateRecommendQueueBlacklist(Long appId, boolean duibaActivity, boolean ownActivity, boolean goods);
	
	/**
	 * 根据传入的参数进行查询
	 * @param appId 应用ID 精确查询
	 */
	public RecommendBlacklistDto findRecommendQueueBlacklistByAppId(Long appId);
	
	/**
	 * 分页查询黑名单
	 * @param offset 偏移量
	 * @param max 查询条数
	 */
	public List<RecommendBlacklistDto> findAllRecommendQueueBlacklist(Integer offset, Integer max);
	
	/**
	 * 查询黑名单总记录数
	 */
	public Long findRecommendQueueBlacklistTotalRecord();
}
