package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/18.
 */
public interface RemoteInternalLetterService {
    /**
     * 管理员保存站内信
     *
     * @param letter 站内信
     * @return 库存数量
     */
    public DubboResult<Boolean> saveInternalLetter(InternalLetterDO letter);

    /**
     * 删除站内信
     *
     * @param letterId 站内信Id
     * @return 是否成功
     */
    public DubboResult<Boolean> deleteInternalLetter(Long letterId);

    /**
     *重载  开发者删除站内信
     *
     * @param developerId 开发者Id
     * @param letterId 站内信Id
     * @return 是否成功
     */
    public DubboResult<Boolean> deleteInternalLetter(Long developerId,Long letterId);

    /**
     *  获取站内信详情
     *
     * @param letterId 站内信Id
     * @return 是否成功
     */
    public DubboResult<InternalLetterDO> getOneInternalLetter(Long letterId);

    /**
     *  管理员获取站内信列表
     *
     * @param param 分页参数
     * @return PaginationVO
     */
    public DubboResult<PaginationVO<InternalLetterDO>> getInternalLetterPage(InternalLetterQueryEntity param);
    /**
     * 开发者获取站内信列表
     *
     * @param param 分页参数
     * @return PaginationVO
     */
    public DubboResult<PaginationVO<InternalLetterKeyDO>> getInternalLetterKeyPage(InternalLetterQueryEntity param);
    /**
     * 开发者设置所有的站内信为已读
     *
     * @param developerId 开发者Id
     * @return PaginationVO
     */
    public DubboResult<Integer> setAllReaded(Long developerId);
    /**
     * 开发者加载站内信详情
     * @param developerId 开发者Id
     * @param letterId 站内信Id
     * @return PaginationVO
     */
    public DubboResult<InternalLetterDO> developerFindInternalLetter(Long developerId,Long letterId);
    /**
     * 开发者获取未读条数
     * @param developerId 开发者Id
     * @return PaginationVO
     */
    public DubboResult<Integer> getNoRead(Long developerId);
}
