package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppExtraParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.AppUrlParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/29.
 */
public interface RemoteAppService {
    /**
     * 创建App,注册时请不要调此服务,因为注册服务会自动完成app的创建
     * @param param
     * @return
     */
    DubboResult<Long> createApp(CreateAppQueryParams param);

    /**
     * 获取App简单字段(可高并发)
     * @param id
     * @return
     */
    DubboResult<AppSimpleDto> getSimpleApp(Long id);

    /**
     * 批量获取App简单字段
     * @param id
     * @return
     */
    DubboResult<List<AppSimpleDto>> getSimpleAppByIds(List<Long> id);

    /**
     * 获取app预算
     * @param id
     * @return
     */
    DubboResult<AppBudgetDto> getAppBudget(Long id);

    /**
     * 更新应用配置信息
     * @param params
     * @return
     */
    DubboResult<Boolean> updateAppInfo(AppInfoFromParams params);

    /**
     * app接口配置
     * @param appUrlParams
     * @return
     */
    DubboResult<Boolean> updateApiConfig(AppUrlParams appUrlParams);

    /**
     * app预算配置
     * @param appBudget
     * @return
     */
    DubboResult<Boolean> updateBudgetConfig(AppBudgetDto appBudget);
    
    /**
     * 功能与updateAppConfig相同，增加了两个字段，updateAppConfig参数列表过多，
     * 故增加此方法。
     * @param appExtraParams
     */
    void saveAppConfig(AppExtraParams appExtraParams);

    /**
     * 通过appKey查询app
     * @param appKey
     * @return
     */
    DubboResult<AppSimpleDto> getAppByAppKey(String appKey);
    
    /**
     * 通过开发者ID查询app的信息
     * @param developerId
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAllByDeveloper(Long developerId);
    
    /**
     * 根据应用名称查询(前模糊)app的信息
     * @param appName 应用名称
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAppNameByNameLike(String appName);
    
    /**
     * 根据应用名称模糊查询前20条
     * @param appName 应用名称
     * @return
     */
    DubboResult<List<AppSimpleDto>> findAppByAppName(String appName);

}
