package cn.com.duiba.developer.center.api.remoteservice.statistics;

import java.util.Date;
import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.statistics.CreditsDistributionDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppCreditsDistributionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * OdpsAppCreditsDistributionService
 */
public interface RemoteOdpsAppCreditsDistributionService {
	/**
	 * 根据App和时间
	 * @param appId
	 * @param day
	 * @return
	 */
	public DubboResult<OdpsAppCreditsDistributionDto> findAppCreditsDistributionByAppIdAndDay(Long appId, String day);

	/**
	 * 根据App和时间获取积分描述
	 * @param appId
	 * @param day
     * @return
     */
	public DubboResult<List<CreditsDistributionDto>> getAppCreditsDistributionByAppIdAndDay(Long appId, Date day);
}
