package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.apache.commons.lang.StringUtils;

import java.net.URL;
import java.util.Date;
import java.util.List;

/**
 * Created by liuyao on 2017/2/9.
 * 楼层代码配置文件解析器
 */
public class DBcongfigAnalytic {
    private static final String OSS_CONFIG_PATH = "duibaFloorCofig/";
    public static final String FILE_TYPE = ".duibaconfig";

    private DBcongfigAnalytic() {
    }

    /**
     * 根据oss 的duibaconfig文件网络地址解析出DBcongfigFileContext
     * 管理员端使用
     *
     * @param fileUrl
     * @return
     * @throws Exception
     */
    public static DBcongfigFileContext parse(String fileUrl) throws DeveloperCenterException {
        if (StringUtils.isBlank(fileUrl) || !fileUrl.endsWith(FILE_TYPE)) {
            throw new DeveloperCenterException("无法解析的地址");
        }
        try {
            URL url = new URL(fileUrl);
            CharSource source = Resources.asCharSource(url, Charsets.UTF_8);

            List<String> lines = source.readLines();
            DBcongfigFileContext context = new DBcongfigFileContext();
            for (String line : lines) {
                context.addLine(line);
            }
            return context;
        } catch (Exception e) {
            throw new DeveloperCenterException(e);
        }
    }

    /**
     * 根据duibaConfig文件内容解析出DBcongfigFileContext
     *
     * @param context
     * @return
     */
    public static DBcongfigFileContext parseContext(String context) {
        Splitter spl = Splitter.on("\n").omitEmptyStrings();
        List<String> lines = spl.splitToList(context);
        DBcongfigFileContext fileContext = new DBcongfigFileContext();
        for (String line : lines) {
            fileContext.addLine(line);
        }
        return fileContext;
    }


    public static String getOssConfigPath(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DBcongfigAnalytic.OSS_CONFIG_PATH);
        stringBuilder.append(fileName).append("-").append(new Date().getTime());
        stringBuilder.append(DBcongfigAnalytic.FILE_TYPE);
        return stringBuilder.toString();
    }

}
