package cn.com.duiba.developer.center.api.domain.enums;

/**
 * 皮肤使用场景
 * Created by xiaoxuda on 2017/3/15.
 */
public enum SkinUsageScenarioEnum {
    DUIBA_LAUNCH(1,"兑吧投放的皮肤"),
    DEVELOPER_CUSTOM(2,"开发者可定制皮肤");

    private Integer code;
    private String desc;

    SkinUsageScenarioEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 通过code获取皮肤应用类型
     * @param code
     * @return
     */
    public static SkinUsageScenarioEnum getByCode(Integer code){
        for(SkinUsageScenarioEnum skinUsageScenarioEnum:values()){
            if(skinUsageScenarioEnum.getCode().equals(code)){
                return skinUsageScenarioEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
