package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.AppNewExtraDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * @author sunyan
 * @version 创建时间：2017年4月12日 下午3:01:46
 */
public interface RemoteAppNewExtraService {
    /**
     * 批量获取AppNewExtra
     * @param appIds
     * @return
     */
     DubboResult<List<AppNewExtraDto>> findByAppIds(List<Long> appIds) ;
     /**
      * 修改bd联系人
      * @param appId
      * @param value
      * @return
      */
     DubboResult<Boolean> updateBd(Long appId,String value);
     /**
      * 修改上月日均活动登录UV
      * @param appId
      * @param value
      * @return
      */
     DubboResult<Boolean> updateDailyActLoginUv(Long appId,String value);
     /**
      * 修改上线时间
      * @param appId
      * @param value
      * @return
      */
     DubboResult<Boolean> updateOnlineDate(Long appId,String value);
     /**
      * 按指定扩展字段和值批量获取AppNewExtra(只含有appId和传入的扩展字段值)
      * @param appIds
      * @return
      */
     DubboResult<List<AppNewExtraDto>> findByKeyValue(String key,String value);
}
