package cn.com.duiba.developer.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.SupplierProductDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by zhengjy on 2016/09/05
 */
public interface RemoteSupplierProductsService {
	/**
	 * 获取上游产品
	 * @param supplier
	 * @return
     */
	public DubboResult<SupplierProductDto> findBySupplier(String supplier);

	/**
	 * 获取上游产品列表
	 * @param supplier
	 * @return
     */
	public DubboResult<List<SupplierProductDto>> findAllBySupplier(String supplier);

	/**
	 * 根据上游名称和商品ID查询上游价格
	 * @param supplier
	 * @param productId
     * @return
     */
	public DubboResult<SupplierProductDto> findBySupplierAndProductId(String supplier,String productId);

	/**
	 * @param supplier
	 * @param facePrice
     * @return
     */
	public DubboResult<List<SupplierProductDto>> findBySupplierAndFacePrice(String supplier,Integer facePrice);

	/**
	 * 根据供应商名称和网络运营商名称查询产品
	 * @param supplier
	 * @param mobile
	 * @return
	 */
	DubboResult<List<SupplierProductDto>> findBySupplierAndMobile(String supplier,String mobile);


	/**
	 * @param supplier
	 * @param mobile
	 * @param province
     * @return
     */
	public DubboResult<List<SupplierProductDto>> findBySupplierAndMobileAndProvince(String supplier,String mobile,String province);

	/**
	 *
	 * @param supplier
	 * @return
     */
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByNameAndFacePrice(String supplier);

	/**
	 *
	 * @param supplier
	 * @return
     */
	public DubboResult<List<SupplierProductDto>> findAllBySupplierOrderByProvinceAndFacePrice(String supplier);

	/**
	 *
	 * @param supplier
	 * @param gameId
     * @return
     */
	public DubboResult<List<SupplierProductDto>> findAllBySupplierAndGameId(String supplier,String gameId);

	/**
	 *
	 * @param ids
	 * @return
     */
	public DubboResult<List<SupplierProductDto>> findAllByIds(List<Long> ids);

	/**
	 *
	 * @param supplierProductDO
     */
	public void insert(SupplierProductDto supplierProductDO);

	/**
	 *
	 * @param supplierProductDO
     */
	public void update(SupplierProductDto supplierProductDO);

	/**
	 *
	 * @param id
	 * @return
     */
	public DubboResult<SupplierProductDto> find(Long id);

	/**
	 * 根据供应商编码，产品id，运营商查询产品
	 * @param supplier
	 * @param productId
	 * @param mobile 运营商名称，不包含“中国”两个字
	 * @return
	 */
	DubboResult<SupplierProductDto> findBySupplierAndProductIdAndMobile(String supplier,String productId,String mobile);
}
