/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class Aspect4RemoteAppService {
    private AdvancedCacheClient advancedCacheClient;

    private static String getKeyByAppId(Long appId) {
        return "dcm_key_appId_" + appId;
    }

    private static String getKeyByAppKey(String appKey) {
        return "dcm_key_appId_" + appKey;
    }

    @Around(value="execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getSimpleApp(..))")
    public Object aroundGetSimpleApp(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result = null;
        Long appId = (Long)proceedingJoinPoint.getArgs()[0];
        if (this.advancedCacheClient != null) {
            result = this.advancedCacheClient.get(Aspect4RemoteAppService.getKeyByAppId(appId));
        }
        result = result != null ? DubboResult.successResult(result) : proceedingJoinPoint.proceed();
        return result;
    }

    @Around(value="execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getAppByAppKey(..))")
    public Object aroundGetAppByAppKey(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object result = null;
        String appKey = (String)proceedingJoinPoint.getArgs()[0];
        if (this.advancedCacheClient != null) {
            result = this.advancedCacheClient.get(Aspect4RemoteAppService.getKeyByAppKey(appKey));
        }
        result = result != null ? DubboResult.successResult(result) : proceedingJoinPoint.proceed();
        return result;
    }

    public void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        this.advancedCacheClient = advancedCacheClient;
    }
}

