/**
 * Project Name:developer-center-api
 * File Name:RemoteTagService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice
 * Date:2016年8月16日上午9:55:22
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppTagDto;
import cn.com.duiba.developer.center.api.domain.dto.AppTagsMaskingDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteTagService <br/>
 * 商品标签dubbo服务 <br/>
 * Date:     2016年8月16日 上午9:55:22 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteTagService {

    /**
     * 
     * 根据appId获取推荐商品标签列表
     *
     * @author zhanglihui
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppTagDto>> getRecommendedTags(Long appId);
    
    /**
     * 设置自动推荐商品标签
     *
     * @author zhanglihui
     * @param appId         app主键
     * @param autoRecommend 是否开启自动推荐
     * @param tagids        标签列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids);

    DubboResult<List<AppTagsMaskingDto>> findAllByTagsIds(List<Long> tagsIds);

    DubboResult<List<Long>> findShieldTagsByAppId(final Long appId);
}

