package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * 首页皮肤宽度
 * Created by xiaoxuda on 2017/8/23.
 */
public enum SkinWidthEnum {
    W640(640, "宽度640"),
    W750(750, "宽度750");

    private static final Map<Integer, SkinWidthEnum> enumMap = new HashMap<>();
    static{
        for(SkinWidthEnum skinWidthEnum : values()){
            enumMap.put(skinWidthEnum.getCode(), skinWidthEnum);
        }
    }

    public static SkinWidthEnum getByCode(Integer code){
        SkinWidthEnum skinWidthEnum = enumMap.get(code);
        if(skinWidthEnum == null){
            throw new DeveloperCenterException("不支持的皮肤尺寸");
        }
        return skinWidthEnum;
    }

    Integer code;
    String desc;

    SkinWidthEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
