/**
 * Project Name:developer-center-api
 * File Name:RemoteOdpsActivity2DailyStatService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice.statistics
 * Date:2016年12月14日上午10:47:33
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppActivityDwmStatDto;
import cn.com.duiba.developer.center.api.domain.vo.DeveloperActivityStatisticsVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * ClassName:RemoteOdpsActivity2DailyStatService <br/>
 * Date:     2016年12月14日 上午10:47:33 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteOdpsActivity2DailyStatService {

    /**
     * 根据appId、开始日期、结束日期查询每日活动统计数据
     * @param appId
     * @param startDay
     * @param endDay
     * @param orderBy
     * @param relationType
     * @return
     */
    DubboResult<List<OdpsAppActivityDwmStatDto>> findSumByAppIdAndDayAndOrderBy(Long appId, Date startDay, Date endDay, String orderBy, String relationType);
    
    /**
     * 
     * findAllByRelationIdAndType:(这里用一句话描述这个方法的作用). <br/>
     * @param activityIds
     * @param relationType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<DeveloperActivityStatisticsVO>> findAllByRelationIdAndType(List<Long> activityIds, Integer relationType);
}

