package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasOrderStatusEnum {
    /**
     * 订单状态：1：处理中；2：通过；3：取消；
     * orderStatus
     */
    ORDER_PROCESS(1,"处理中"),
    ORDER_PASS(2,"通过"),
    ORDER_CANCEL(3,"取消");

    private static final Map<Integer, SaasOrderStatusEnum> enumMap = new HashMap<>();
    static{
        for(SaasOrderStatusEnum saasOrderStatusEnum : values()){
            enumMap.put(saasOrderStatusEnum.getValue(), saasOrderStatusEnum);
        }
    }
    public static SaasOrderStatusEnum getByCode(Integer code){
        SaasOrderStatusEnum saasOrderStatusEnum = enumMap.get(code);
        if(saasOrderStatusEnum == null){
            throw new DeveloperCenterException("不支持的订单状态");
        }
        return saasOrderStatusEnum;
    }
    private int    value;
    private String desc;

    SaasOrderStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
