package cn.com.duiba.developer.center.api.domain.paramquery;

import java.io.Serializable;

/**
 * @author: chengsiyi
 * @date: 2018/4/12 13:54
 * 分页查询条件封装类
 * 同时也是所有分页查询类的父类
 */
public class PageQueryParam implements Serializable {

    private static final long serialVersionUID = -6502590434557381440L;

    private Integer pageNo;

    private Integer pageSize;

    /**
     * 无参构造函数
     */
    public PageQueryParam() {
        this.pageSize = 20;
        this.pageNo = 0;
    }

    /**
     * @param pageNo 页码
     * @param pageSize 每页容量
     */
    public PageQueryParam(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
