package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasOrderParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by zyj on 2018/4/7.
 */
@AdvancedFeignClient
public interface RemoteSaasOrderService {
    /**
     * 新增订单
     * @param SaasOrderDto
     * @return
     */
    public  DubboResult<Boolean> insert(SaasOrderDto SaasOrderDto);

    /**
     * 筛选
     * @param saasOrderParams
     * @return
     */
    DubboResult<List<SaasOrderDto>> selectListByParams(SaasOrderParams saasOrderParams);

    /**
     * 查询总数量
     * @param saasOrderParams
     * @return
     */
    DubboResult<Integer> selectCountByParams(SaasOrderParams saasOrderParams);

    /**
     * update
     *
     */
    DubboResult<Integer> updateSaasOrder(SaasOrderDto SaasOrderDto);

    /**
     * 通过id查询订单
     */
    DubboResult<SaasOrderDto> findSaasOrderById(Long id);
}
