package cn.com.duiba.developer.center.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemDwmStatDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppItemWeekMonthStatDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * OdpsAppItemDwmStatService
 */
@AdvancedFeignClient
public interface RemoteOdpsAppItemDwmStatService {

	/**
	 * 根据appId和开始日期，结束日期，查询
	 * @param appId
	 * @param startDay
	 * @param endDay
     * @return
     */
	public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);

	/**
	 * 根据appId和开始日期，结束日期，查询周月
	 * @param appId
	 * @param startDay
	 * @param endDay
	 * @param relationId
	 * @param relationType
     * @return
     */
	public DubboResult<OdpsAppItemWeekMonthStatDto> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, Long relationId, Integer relationType);


    /**
	 * 根据appId和开始日期，结束日期
	 * @param params
	 * @return
     */
	public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayAndOrderBy(Map<String, Object> params);

	/**
	 * 根据appId和开始日期，结束日期
	 * @param params
	 * @return
     */
	public DubboResult<List<OdpsAppItemDwmStatDto>> findSumByAppIdAndDayAndIdAndTypeAndOrderBy(Map<String, Object> params);

	/**
	 * 根据appId和开始日期，结束日期，查询周月
	 * @param appId
	 * @param startDay
	 * @param endDay
	 * @param relationIds
	 * @param relationType
     * @return
     */
	@RequestMapping("findWeekAndMonthByAppIdAndDayWithIdList")
	public DubboResult<List<OdpsAppItemWeekMonthStatDto>> findWeekAndMonthByAppIdAndDay(Long appId, Date startDay, Date endDay, List<Long> relationIds, Integer relationType);
}
