package cn.com.duiba.developer.center.api.domain.dto.saas;

import cn.com.duiba.developer.center.api.domain.enums.saas.OrderSourceEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.PaymentMethodEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasDateLimitTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasOrderPayTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasOrderStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author kimi
 */
public class SaasOrderDto implements Serializable {
    private static final long serialVersionUID = 5454155825314635342L;
    
    /** 
     * 主键 
     **/
    private Long id;
    /** 
     * appID 
     **/
    private Long appId;
    /** 
     * 开发者联系方式 
     **/
    private String phone;
    /** 
     * 开发者姓名 
     **/
    private String devName;
    /** 
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤； 
     **/
    private SaasFuncTypeEnum funcType;
    /** 
     * 功能子类型（活动类型，商城皮肤、签到皮肤、活动皮肤） 
     **/
    private Integer funcSubType;
    /** 
     * 关联ID（活动、签到） 
     **/
    private Long funcRelId;
    /** 
     * 订单类型：1：购买；2：续费； 
     **/
    private SaasOrderPayTypeEnum orderType;
    /** 
     * 订单市场价格,单位(分)
     **/
    private Long orderPrice;
    /**
     * 订单实际价格,单位(分)
     */
    private Long orderActualPrice;
    /**
     * 订单来源,1:线上(开发者创建),2:代理商添加,3:手动添加（兑吧管理员）
     */
    private OrderSourceEnum orderSource;
    /**
     * 代理商ID,管理员ID,开发者ID(根据订单创建类型决定)
     */
    private Long relId;

    /**
     * 授权ID 
     **/
    private Long grantId;
    /** 
     * 订单状态：1：处理中；2：通过；3：取消； 
     **/
    private SaasOrderStatusEnum orderStatus;
    /** 
     * 订单终态备注 
     **/
    private String remarkFinalStatus;
    /** 
     * 管理员输入的订单备注 
     **/
    private String remarkAdmin;
    /** 
     * 授权操作者ID（兑吧管理员） 
     **/
    private Long operatorId;
    /** 
     * 授权时间 
     **/
    private Date grantDate;
    /** 
     * 期限类型，1：日；2：周；3：月；4：季度；5：年； 
     **/
    private SaasDateLimitTypeEnum dateLimitType;
    /** 
     * 购买数量，授权之前管理员可修改 
     **/
    private Integer limitCount;
    /**
     * 付款方式:1:线下;2:支付宝;3:账户余额
     */
    private PaymentMethodEnum paymentMethod;
    /** 
     * 创建时间 
     **/
    private Date gmtCreate;
    /** 
     * 修改时间 
     **/
    private Date gmtModified;



    public OrderSourceEnum getOrderSource() {
        return orderSource;
    }

    public void setOrderSource(OrderSourceEnum orderSource) {
        this.orderSource = orderSource;
    }

    public Long getOrderActualPrice() {
        return orderActualPrice;
    }

    public PaymentMethodEnum getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setOrderActualPrice(Long orderActualPrice) {
        this.orderActualPrice = orderActualPrice;
    }
    public void setId(Long value) {
        this.id = value;
    }
    public Long getId() {
        return this.id;
    }
    
    public void setAppId(Long value) {
        this.appId = value;
    }
    public Long getAppId() {
        return this.appId;
    }
    
    public void setPhone(String value) {
        this.phone = value;
    }
    public String getPhone() {
        return this.phone;
    }
    
    public void setDevName(String value) {
        this.devName = value;
    }
    public String getDevName() {
        return this.devName;
    }
    

    public void setFuncSubType(Integer value) {
        this.funcSubType = value;
    }
    public Integer getFuncSubType() {
        return this.funcSubType;
    }
    
    public void setFuncRelId(Long value) {
        this.funcRelId = value;
    }
    public Long getFuncRelId() {
        return this.funcRelId;
    }
    

    public void setOrderPrice(Long value) {
        this.orderPrice = value;
    }
    public Long getOrderPrice() {
        return this.orderPrice;
    }
    
    public void setGrantId(Long value) {
        this.grantId = value;
    }
    public Long getGrantId() {
        return this.grantId;
    }
    

    public void setRemarkFinalStatus(String value) {
        this.remarkFinalStatus = value;
    }
    public String getRemarkFinalStatus() {
        return this.remarkFinalStatus;
    }
    
    public void setRemarkAdmin(String value) {
        this.remarkAdmin = value;
    }
    public String getRemarkAdmin() {
        return this.remarkAdmin;
    }
    
    public void setOperatorId(Long value) {
        this.operatorId = value;
    }
    public Long getOperatorId() {
        return this.operatorId;
    }
    
    public void setGrantDate(Date value) {
        this.grantDate = value;
    }
    public Date getGrantDate() {
        return this.grantDate;
    }

    public SaasFuncTypeEnum getFuncType() {
        return funcType;
    }

    public void setFuncType(SaasFuncTypeEnum funcType) {
        this.funcType = funcType;
    }

    public SaasDateLimitTypeEnum getDateLimitType() {
        return dateLimitType;
    }

    public void setDateLimitType(SaasDateLimitTypeEnum dateLimitType) {
        this.dateLimitType = dateLimitType;
    }

    public SaasOrderStatusEnum getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(SaasOrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public SaasOrderPayTypeEnum getOrderType() {
        return orderType;
    }

    public void setOrderType(SaasOrderPayTypeEnum orderType) {
        this.orderType = orderType;
    }

    public void setLimitCount(Integer value) {
        this.limitCount = value;
    }
    public Integer getLimitCount() {
        return this.limitCount;
    }
    
    public void setGmtCreate(Date value) {
        this.gmtCreate = value;
    }
    public Date getGmtCreate() {
        return this.gmtCreate;
    }
    
    public void setGmtModified(Date value) {
        this.gmtModified = value;
    }
    public Date getGmtModified() {
        return this.gmtModified;
    }
    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }
}

