package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/24.
 */
public enum SaasGrantUseStatusEnum {
    /**
     * 使用状态:1:使用中,2:已过期
     * status
     */
    IN_USE(1, "使用中"),
    OVER_DUE(2, "已过期");

    private static final Map<Integer, SaasGrantUseStatusEnum> enumMap = new HashMap<>();
    static{
        for(SaasGrantUseStatusEnum saasGrantUseStatusEnum : values()){
            enumMap.put(saasGrantUseStatusEnum.getValue(), saasGrantUseStatusEnum);
        }
    }

    public static SaasGrantUseStatusEnum getByCode(Integer code){
        SaasGrantUseStatusEnum saasGrantUseStatusEnum = enumMap.get(code);
        if(saasGrantUseStatusEnum == null){
            throw new DeveloperCenterException("不支持的功能类型");
        }
        return saasGrantUseStatusEnum;
    }

    private int    value;
    private String desc;

    SaasGrantUseStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
