/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasGrantDto;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasMallTypeEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasGrantQueryParam;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasDevFreeService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasGrantService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasGrantUtil {
    private static Logger logger = LoggerFactory.getLogger(SaasGrantUtil.class);
    private static RemoteSaasGrantService remoteSaasGrantService;
    private static RemoteSaasDevFreeService remoteSaasDevFreeService;
    private static AdvancedCacheClient advancedCacheClient;
    public static final Date freeDeadline;
    public static final Date chargeStartDate;
    public static final Long PROBATION_LIMIT_IN_DAY;
    private static Cache<Long, Boolean> freeDevCache;
    private static Cache<String, Boolean> grantCache;

    public static boolean isFreeDev(Long developerId, boolean degradedRunning) {
        try {
            if (developerId == null) {
                return false;
            }
            return (Boolean)freeDevCache.get((Object)developerId, () -> Boolean.TRUE.equals(remoteSaasDevFreeService.isExist(developerId)));
        }
        catch (ExecutionException e) {
            logger.warn("\u5f00\u53d1\u8005\u767d\u540d\u5355\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    private static String generateKey(Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) {
        StringBuilder builder = new StringBuilder();
        builder.append(appId).append("_").append((Object)funcType).append("_").append(funcSubType == null ? SaasGrantDto.DEFAULT_FUNC_SUB_TYPE : funcSubType).append("_").append(funcRelId == null ? SaasGrantDto.DEFAULT_FUNC_REL_ID : funcRelId);
        return builder.toString();
    }

    private static boolean hasGrant(AppSimpleDto app, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) throws ExecutionException {
        if (app == null || funcType == null) {
            return false;
        }
        if (System.currentTimeMillis() < chargeStartDate.getTime()) {
            return true;
        }
        if (SaasGrantUtil.isFreeDev(app.getDeveloperId(), true)) {
            return true;
        }
        String key = SaasGrantUtil.generateKey(app.getId(), funcType, funcSubType, funcRelId);
        return (Boolean)grantCache.get((Object)key, () -> Boolean.TRUE.equals(remoteSaasGrantService.hasGrant(new SaasGrantQueryParam(app.getId(), funcType, funcSubType, funcRelId))));
    }

    public static boolean hasCreditsMallGrant(AppSimpleDto app, boolean degradedRunning) {
        try {
            for (SaasMallTypeEnum typeEnum : SaasMallTypeEnum.values()) {
                if (!SaasGrantUtil.hasGrant(app, SaasFuncTypeEnum.CREDITS_MALL, typeEnum.getValue(), null)) continue;
                return true;
            }
            return false;
        }
        catch (ExecutionException e) {
            logger.warn("\u5546\u57ce\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static boolean hasSignGrant(AppSimpleDto app, Long signActId, Date actOptTime, boolean degradedRunning) {
        try {
            if (app == null || signActId == null) {
                return false;
            }
            if (actOptTime != null && actOptTime.getTime() < chargeStartDate.getTime()) {
                return true;
            }
            boolean signGrant = SaasGrantUtil.hasCreditsMallGrant(app, true);
            if (!signGrant) {
                signGrant = SaasGrantUtil.hasGrant(app, SaasFuncTypeEnum.SIGN, null, signActId);
            }
            return signGrant;
        }
        catch (ExecutionException e) {
            logger.warn("\u7b7e\u5230\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static boolean hasActGrant(AppSimpleDto app, Integer actType, Long actId, Date actOptTime, boolean degradedRunning) {
        try {
            if (app == null || actType == null || actId == null) {
                return false;
            }
            if (actOptTime != null && actOptTime.getTime() < chargeStartDate.getTime()) {
                return true;
            }
            boolean actGrant = SaasGrantUtil.hasGrant(app, SaasFuncTypeEnum.ACTIVITY, actType, actId);
            if (!actGrant) {
                actGrant = SaasGrantUtil.hasCreditsMallGrant(app, true);
            }
            return actGrant;
        }
        catch (ExecutionException e) {
            logger.warn("\u6d3b\u52a8\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static boolean checkGrant(AppSimpleDto app, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId, Date actOptTime, boolean degradedRunning) {
        try {
            boolean hasGrant = SaasFuncTypeEnum.CREDITS_MALL.equals((Object)funcType) ? SaasGrantUtil.hasCreditsMallGrant(app, degradedRunning) : (SaasFuncTypeEnum.SIGN.equals((Object)funcType) ? SaasGrantUtil.hasSignGrant(app, funcRelId, actOptTime, degradedRunning) : (SaasFuncTypeEnum.ACTIVITY.equals((Object)funcType) ? SaasGrantUtil.hasActGrant(app, funcSubType, funcRelId, actOptTime, degradedRunning) : true));
            if (hasGrant) {
                return true;
            }
            if (System.currentTimeMillis() < freeDeadline.getTime()) {
                return true;
            }
            Long visitCount = (Long)advancedCacheClient.get(app.getId().toString());
            visitCount = visitCount == null ? 1L : visitCount;
            hasGrant = visitCount <= PROBATION_LIMIT_IN_DAY;
            if (hasGrant) {
                visitCount = visitCount + 1L;
                advancedCacheClient.set(app.getId().toString(), (Object)visitCount, DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            }
            return hasGrant;
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\uff0c\u662f\u5426\u964d\u7ea7\uff1a", (Object)degradedRunning, (Object)e);
            return degradedRunning;
        }
    }

    public static void setRemoteSaasGrantService(RemoteSaasGrantService remoteSaasGrantService) {
        SaasGrantUtil.remoteSaasGrantService = remoteSaasGrantService;
    }

    public static void setRemoteSaasDevFreeService(RemoteSaasDevFreeService remoteSaasDevFreeService) {
        SaasGrantUtil.remoteSaasDevFreeService = remoteSaasDevFreeService;
    }

    public static void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        SaasGrantUtil.advancedCacheClient = advancedCacheClient;
    }

    static {
        freeDeadline = DateUtils.getSecondDate((String)"2018-08-01 00:00:00");
        chargeStartDate = DateUtils.getSecondDate((String)"2018-04-25 00:00:00");
        PROBATION_LIMIT_IN_DAY = 100L;
        freeDevCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        grantCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(10000L).build();
    }
}

