package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum AuditStatusEnum {
    /**
     * 审核状态
     * auditStatus
     */
    WAIT_AUDIT(1,"待审核"),
    PASS_AUDIT(2,"审核通过"),
    REFUSE_AUDIT(3,"审核拒绝");

    private static final Map<Integer, AuditStatusEnum> enumMap = new HashMap<>();
    static{
        for(AuditStatusEnum auditStatusEnum : values()){
            enumMap.put(auditStatusEnum.getValue(), auditStatusEnum);
        }
    }

    public static AuditStatusEnum getByCode(Integer code){
        AuditStatusEnum auditStatusEnum = enumMap.get(code);
        if(auditStatusEnum == null){
            throw new DeveloperCenterException("不支持的状态类型");
        }
        return auditStatusEnum;
    }

    private int    value;
    private String desc;

    AuditStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
