package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.dto.PageDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasDevFreeDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasWhiteListParams;

import java.util.List;

/**
 * Created by zyj on 2018/4/7.
 */
@AdvancedFeignClient
public interface RemoteSaasDevFreeService {

    /**
     * 新增白名单
     *
     * @param saasDevFreeDto 开发者ID
     * @return
     */
    Boolean insert(SaasDevFreeDto saasDevFreeDto);

    /**
     * 删除白名单
     *
     * @param developerId 开发者ID
     * @return
     */
    Boolean delete(Long developerId);

    /**
     * 判断是否已经是白名单
     *
     * @param developerId 开发者ID
     * @return
     */
    Boolean isExist(Long developerId);

    /**
     * 获取白名单列表
     *
     * @param params
     * @return
     */
    PageDto<DeveloperDto> findPageList(SaasWhiteListParams params);

    /**
     * 获取在数据库中的developerIds
     *
     * @param developerId
     * @return
     */
    List<Long> getDeveloperIdS(List<Long> developerId);
}
