package cn.com.duiba.developer.center.api.domain.param;

import cn.com.duiba.developer.center.api.domain.enums.saas.SaasDateLimitTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;

import java.io.Serializable;

/**
 * Created by xiaoxuda on 2018/4/12.
 */
public class SaasGrantParam implements Serializable {
    private static final long serialVersionUID = 4072064149592504522L;

    /**
     * appID
     **/
    private Long appId;
    /**
     * 功能类型：1，积分商城；2.签到；3：活动；4：皮肤；
     **/
    private SaasFuncTypeEnum funcType;
    /**
     * 功能子类型（活动类型，商城皮肤、签到皮肤、活动皮肤）
     **/
    private Integer funcSubType;
    /**
     * 关联ID（活动、签到）
     **/
    private Long funcRelId;
    /**
     * 期限类型，1：日；2：周；3：月；4：季度；5：年；
     **/
    private SaasDateLimitTypeEnum dateLimitType;
    /**
     * 购买数量，授权之前管理员可修改
     **/
    private Integer limitCount;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SaasFuncTypeEnum getFuncType() {
        return funcType;
    }

    public void setFuncType(SaasFuncTypeEnum funcType) {
        this.funcType = funcType;
    }

    public Integer getFuncSubType() {
        return funcSubType;
    }

    public void setFuncSubType(Integer funcSubType) {
        this.funcSubType = funcSubType;
    }

    public Long getFuncRelId() {
        return funcRelId;
    }

    public void setFuncRelId(Long funcRelId) {
        this.funcRelId = funcRelId;
    }

    public SaasDateLimitTypeEnum getDateLimitType() {
        return dateLimitType;
    }

    public void setDateLimitType(SaasDateLimitTypeEnum dateLimitType) {
        this.dateLimitType = dateLimitType;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }
}
