package cn.com.duiba.developer.center.api.domain.paramquery;

import cn.com.duiba.developer.center.api.domain.enums.saas.OrderSourceEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasMallTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasOrderStatusEnum;

import java.util.List;

/**
 * @author zyj
 * @date 2018/4/9
 */
public class SaasOrderParams extends PageQueryParam {
    private static final long serialVersionUID = 3936053458040644360L;
    /**
     * 订单状态
     */
    private SaasOrderStatusEnum orderStatus;
    private List<Long> appIds;
    /**
     * dao层不会进行email查询，dba不让这么做
     */
    private String email;
    private String devName;
    private Long appId;
    private SaasMallTypeEnum funcSubType;


    /**
     * 电话号码
     */
    private String phone;

    /**
     * 开始时间
     * 1.2018-01-01
     */
    private String startTime;

    /**
     * 结束时间
     * 1.2018-01-01
     */
    private String endTime;

    /**
     * 代理商ID,管理员ID,开发者ID(根据订单创建类型决定)
     */
    private Long relId;

    private OrderSourceEnum orderSource;

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public OrderSourceEnum getOrderSource() {
        return orderSource;
    }

    public void setOrderSource(OrderSourceEnum orderSource) {
        this.orderSource = orderSource;
    }

    public SaasOrderStatusEnum getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(SaasOrderStatusEnum orderStatus) {
        this.orderStatus = orderStatus;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDevName() {
        return devName;
    }

    public void setDevName(String devName) {
        this.devName = devName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SaasMallTypeEnum getFuncSubType() {
        return funcSubType;
    }

    public void setFuncSubType(SaasMallTypeEnum funcSubType) {
        this.funcSubType = funcSubType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}
