package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @version Created by zhenghuan on 2018/5/25 0025
 */
public enum AvailableEnum {
    /**
     * 不可用
     */
    NOT_AVAILABLE(0, "不可用"),
    AVAILABLE(1, "可用");
    private Integer code;
    private String desc;

    private static final Map<Integer, AvailableEnum> ENUM_MAP = new HashMap<>();

    static{
        for(AvailableEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static AvailableEnum getByCode(Integer code){
        AvailableEnum result = ENUM_MAP.get(code);
        if(result == null){
            throw new DeveloperCenterException("不支持的进度类型");
        }
        return result;
    }
    AvailableEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isAvailable(Integer code) {
        return AVAILABLE.code.equals(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
