package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasOrderParams;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasOrderUntreatParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by zyj on 2018/4/7.
 */
@AdvancedFeignClient
public interface RemoteSaasOrderService {
    /**
     * 新增订单
     *
     * @param SaasOrderDto
     * @return
     */
    public Long insert(SaasOrderDto SaasOrderDto);

    /**
     * 筛选
     *
     * @param saasOrderParams
     * @return
     */
    DubboResult<List<SaasOrderDto>> selectListByParams(SaasOrderParams saasOrderParams);

    /**
     * 获取导出数据
     * @param saasOrderParams 筛选条件
     * @return
     */
    List<SaasOrderDto> getExportData(SaasOrderParams saasOrderParams);

    /**
     * 查询总数量
     *
     * @param saasOrderParams
     * @return
     */
    DubboResult<Integer> selectCountByParams(SaasOrderParams saasOrderParams);

    /**
     * update
     */
    DubboResult<Integer> updateSaasOrder(SaasOrderDto SaasOrderDto);

    /**
     * 通过id查询订单
     */
    DubboResult<SaasOrderDto> findSaasOrderById(Long id);

    /**
     * 删除订单
     */
    boolean deleteById(Long id);

    /**
     * 通过功能类型和订单状态查询
     */

    List<SaasOrderDto> findOrderBySaasOrderUntreatParam(SaasOrderUntreatParams saasOrderUntreatParam);

    /**
     * 筛选
     *
     * @param saasOrderParams
     * @return
     */
    List<SaasOrderDto> listByParams(SaasOrderParams saasOrderParams);

    /**
     * 查询总数量
     *
     * @param saasOrderParams
     * @return
     */
    Integer countByParams(SaasOrderParams saasOrderParams);
}
