package cn.com.duiba.developer.center.api.remoteservice.expsystem;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.expsystem.ExpChangeChannelDto;
import cn.com.duiba.developer.center.api.domain.dto.expsystem.ExpPrivilegeDto;
import cn.com.duiba.developer.center.api.domain.dto.expsystem.ExpSystemDto;
import cn.com.duiba.developer.center.api.domain.dto.expsystem.ExpSystemLevelDto;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Created by qianjue on 2018/5/2.
 */
@AdvancedFeignClient
public interface RemoteExpSystemService {

	/**
	 * 分页查询经验体系列表
	 * @param title
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	PaginationVO<ExpSystemDto> queryExpSystemList(String title, Integer pageNo, Integer pageSize);
	/**
	 * 根据经验体系ID查询对应的等级配置信息
	 * @param expId
	 * @return
	 */
	List<ExpSystemLevelDto> findExpLevelListByExpId(Long expId);

	/**
	 * 根据经验体系ID查询经验获取和消耗配置表
	 * @param expId
	 * @return
	 */
	List<ExpChangeChannelDto> findExpChangeChannelListByExpId(Long expId);

	/**
	 * 根据经验体系ID和等级，查询对应等级的获取/消耗配置
	 * @param expId
	 * @param level
	 * @return
	 */
	ExpChangeChannelDto getExpChangeChannelByLevel(Long expId,Integer level);

	/**
	 * 根据经验体系ID查询对应的福利配置列表
	 * @param expId
	 * @return
	 */
	List<ExpPrivilegeDto> findExpPrivilegeListByExpId(Long expId);

	/**
	 * 根据经验体系ID和等级，查询对应等级的福利列表
	 * @param expId
	 * @param level
	 * @return
	 */
	List<ExpPrivilegeDto> findExpPrivilegeListByLevel(Long expId,Integer level);

	/**
	 * 根据AppId查询当前App有效的定向经验体系配置
	 * @param appId
	 * @return
	 */
	ExpSystemDto  findVaildExpSystemByAppId(Long appId);

	/**
	 * 新增经验体系
	 * @param expSystemInfo
	 * @return
	 */
	Boolean saveExpSystem(ExpSystemDto expSystemInfo);

	/**
	 * 更新经验体系
	 * @param expSystemInfo
	 * @return
	 */
	Boolean updateExpSystem(ExpSystemDto expSystemInfo);

	/**
	 * 定向
	 * @param expId
	 * @param appId
	 * @return
	 */
	Boolean doSpecify(Long expId,Long appId);
}
