package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/21.
 */
public enum OrderSourceEnum {
    /**
     * 订单来源
     * orderSource
     */
    FROM_DEVELOPER(1,"开发者创建"),
    FROM_AGENT(2,"代理商创建"),
    FROM_ADMIN(3,"管理员创建");

    private static final Map<Integer, OrderSourceEnum> enumMap = new HashMap<>();
    static{
        for(OrderSourceEnum orderSourceEnum : values()){
            enumMap.put(orderSourceEnum.getValue(), orderSourceEnum);
        }
    }

    public static OrderSourceEnum getByCode(Integer code){
        OrderSourceEnum orderSourceEnum = enumMap.get(code);
        if(orderSourceEnum == null){
            throw new DeveloperCenterException("不支持的进度类型");
        }
        return orderSourceEnum;
    }

    private int    value;
    private String desc;

    OrderSourceEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
