package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2018/4/26.
 */
public enum PaymentMethodEnum {
    /**
     * 支付方式
     * paymentMethod
     */
    UNDER_LINE(1,"线下"),
    ALIPAY(2,"支付宝"),
    ACCOUNT_BALANCE(3,"账户余额");

    private static final Map<Integer, PaymentMethodEnum> enumMap = new HashMap<>();
    static{
        for(PaymentMethodEnum PaymentMethodEnum : values()){
            enumMap.put(PaymentMethodEnum.getValue(), PaymentMethodEnum);
        }
    }

    public static PaymentMethodEnum getByCode(Integer code){
        PaymentMethodEnum PaymentMethodEnum = enumMap.get(code);
        if(PaymentMethodEnum == null){
            throw new DeveloperCenterException("不支持的支付类型");
        }
        return PaymentMethodEnum;
    }

    private int    value;
    private String desc;

    PaymentMethodEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
