package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 皮肤类型枚举
 * Created by xiaoxuda on 2017/2/16.
 */
public enum SkinTypeEnum {
    CREDITS(0,"积分商城"),
    NO_CREDITS(1,"简版商城"),
    SUBPAGE(2,"兑吧投放子页面"),
    SUBPAGE_CUSTOM(3,"开发者可定制子页面"),

    /**
     *  积分商城3.6.2 可自定义子页面/兑换商城
     */
    SUBPAGE_CUSTOM_EXCHANGEMALL(4,"开发者可定制子页面/兑换商城");

    private Integer code;
    private String desc;

    SkinTypeEnum(Integer code,String desc){
        this.code=code;
        this.desc=desc;
    }

    /**
     * 通过类型获取类型枚举
     * @param code
     * @return
     */
    public static SkinTypeEnum getByType(Integer code){
        for(SkinTypeEnum skinTypeEnum:values()){
            if(skinTypeEnum.code.equals(code)){
                return skinTypeEnum;
            }
        }
        throw new DeveloperCenterException("楼层类型解析异常:"+code);
    }

    /**
     * 获取子页面皮肤类型
     * @return
     */
    public static List<SkinTypeEnum> getSubpage(){
        List<SkinTypeEnum> set = Lists.newArrayList(SUBPAGE, SUBPAGE_CUSTOM);
        return set;
    }

    /**
     * 获取首页皮肤类型
     * @return
     */
    public static List<SkinTypeEnum> getHomepage(){
        List<SkinTypeEnum> set = Lists.newArrayList(CREDITS, NO_CREDITS);
        return set;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
