package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.PageDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasChargeApplyDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasChargeApplyParams;

/**
 * @author chengsiyi
 * @date 2018/5/25 11:55
 */
@AdvancedFeignClient
public interface RemoteSaasChargeApplyService {

    /**
     * 获取代理商充值列表
     *
     * @param params 搜索参数
     * @return 充值列表
     */
    PageDto<SaasChargeApplyDto> findChargeList(SaasChargeApplyParams params);

    /**
     * 查看充值单详情
     * @param id 充值单号
     * @return 充值单信息
     */
    SaasChargeApplyDto findById(Long id);

    /**
     * 提交充值申请
     * @param apply 充值信息
     * @return 提交结果
     */
    Boolean commitChargeApply(SaasChargeApplyDto apply);

    /**
     * 充值单审核
     * @param auditParam 审核信息
     * @return 充值单信息
     */
    Boolean financialAudit(SaasChargeApplyDto auditParam);
}
