package cn.com.duiba.developer.center.api.utils;

/**
 * 等级信息获取接口
 * Created by xiaoxuda on 2016/12/20.
 */
public interface VipLimitInfoGetter<T> {
    /**
     * 获取vip等级限制模式
     * @return 兑换限制类型
     * {@link cn.com.duiba.developer.center.api.domain.enums.VipLimitTypeEnum}
     **/
    Integer getVipLimitType(T t);

    /**
     * 获取vip限制等级
     * @return 限制等级配置(等级/位运算)
     **/
    Long getVipLimits(T t);
}
