package cn.com.duiba.developer.center.api.domain.dto.visualeditor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author author
 */
public class VisualEditorSkinUnitDto implements Serializable {

    private static final long serialVersionUID = 7619996521906995666L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 组件名称
     * isNullAble:1
     */
    private String unitName;

    /**
     * 组件分类
     * isNullAble:0,defaultVal:0
     */
    private Integer unitGroupCode;
    /**
     * 组件key,前端使用,唯一
     */
    private String unitKey;
    /**
     * 组件配置数据
     */
    private String configDataJson;
    /**
     * 上下架标识( 0-隐藏 1-开启)
     */
    private Integer openStatus;
    /**
     * 定向状态(0-公用 1-定向)
     */
    private Integer direction;

    /**
     * 组件url
     * isNullAble:1
     */
    private String unitUrl;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    public String getUnitKey() {
        return unitKey;
    }

    public void setUnitKey(String unitKey) {
        this.unitKey = unitKey;
    }

    public String getConfigDataJson() {
        return configDataJson;
    }

    public void setConfigDataJson(String configDataJson) {
        this.configDataJson = configDataJson;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitGroupCode(Integer unitGroupCode) {
        this.unitGroupCode = unitGroupCode;
    }

    public Integer getUnitGroupCode() {
        return this.unitGroupCode;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getDirection() {
        return direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public void setUnitUrl(String unitUrl) {
        this.unitUrl = unitUrl;
    }

    public String getUnitUrl() {
        return this.unitUrl;
    }


    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    @Override
    public String toString() {
        return "VisualEditorSkinUnit{" +
                "id='" + id + '\'' +
                "unitName='" + unitName + '\'' +
                "unitGroupCode='" + unitGroupCode + '\'' +
                "openStatus='" + openStatus + '\'' +
                "unitUrl='" + unitUrl + '\'' +
                "gmtModified='" + gmtModified + '\'' +
                "gmtCreate='" + gmtCreate + '\'' +
                '}';
    }
}
