package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasGrantDto;
import cn.com.duiba.developer.center.api.domain.param.SaasGrantParam;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasGrantParams;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasGrantQueryParam;

import java.util.List;

/**
 * Created by xiaoxuda on 2018/4/12.
 */
@AdvancedFeignClient
public interface RemoteSaasGrantService {
    /**
     * 授权或续费权限，返回新的授权信息
     * @param
     * @return
     */
    SaasGrantDto grantFunc(SaasGrantParam param) throws BizException;

    /**
     * 授权查询
     * 积分商城时不验证funcSubType与funcRelId
     * @param param
     * @return
     */
    SaasGrantDto findGrant(SaasGrantQueryParam param);

    /**
     * 主键查询
     * @param grantId
     * @return
     */
    SaasGrantDto findById(Long grantId);

    /**
     * 查询是否有某个功能的有效权限
     * @param param
     * @return
     */
    Boolean hasGrant(SaasGrantQueryParam param);

    /**
     * 查询count
     */
    Integer selectGrantCountByParams(SaasGrantParams saasGrantParams);

    /**
     * 查询权限
     */
    List<SaasGrantDto> selectGrantListByParams(SaasGrantParams saasGrantParams);

    /**
     * 查询已购买服务
     * @param saasGrantParams
     * @return
     */
    List<SaasGrantDto> selectGrantByAppId(SaasGrantParams saasGrantParams);

    /**
     * 查询已购买积分商城版本
     * @param param
     * @return
     */
    SaasGrantDto findGrantVersionByAppId(SaasGrantQueryParam param);
}
