package cn.com.duiba.developer.center.api.domain.dto.statistics;

import java.io.Serializable;
import java.util.Date;

/**
 * 谁知道谁写一下
 */
public class OdpsAppRetentionReportDto implements Serializable {
    private static final long serialVersionUID = -341L;

	private Long appId;
	private Long newUserNum=0L; //新增用户
	private String yRetentionRates; //次日留存率
	private String wRetentionRates; //7天留存率
	private String mRetentionRates; //30天留存率
	private Date day;

    /**
     * 无参构造函数
     */
    public OdpsAppRetentionReportDto(){
        this.day = new Date();
    }

    /**
     * 指定应用构造函数
     * @param appId 应用Id
     * @param day 日期
     */
	public OdpsAppRetentionReportDto(Long appId, Date day){
		this.appId=appId;
		this.day=day;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getNewUserNum() {
		return newUserNum;
	}

	public void setNewUserNum(Long newUserNum) {
		this.newUserNum = newUserNum;
	}

    /**
     * 获取次日留存率
     * @return 次日留存率
     */
    public String getyRetentionRates() {
        return yRetentionRates;
    }

    /**
     * 设置次日留存率
     * @param yRetentionRates 次日留存率
     */
    public void setyRetentionRates(String yRetentionRates) {
        this.yRetentionRates = yRetentionRates;
    }
    /**
     * 获取7天留存率
     * @return 7天留存率
     */
    public String getwRetentionRates() {
        return wRetentionRates;
    }

    /**
     * 设置7天留存率
     * @param wRetentionRates 7天留存率
     */
    public void setwRetentionRates(String wRetentionRates) {
        this.wRetentionRates = wRetentionRates;
    }
    /**
     * 获取30天留存率
     * @return 30天留存率
     */
    public String getmRetentionRates() {
        return mRetentionRates;
    }

    /**
     * 设置30天留存率
     * @param mRetentionRates 30天留存率
     */
    public void setmRetentionRates(String mRetentionRates) {
        this.mRetentionRates = mRetentionRates;
    }

    public Date getDay() {
        return day;
    }

    
    public void setDay(Date day) {
        this.day = day;
    }

}
