package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/8/9 0009 14:57
 */

import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorUnitGroupDto;

import java.util.ArrayList;
import java.util.List;

/**
 * 组件类型枚举
 * 1.可视化编辑器使用
 */
public enum UnitsGroupEnum {
    SINGLE_COLUMN(1, "单列图组件"),
    DOUBLE_COLUMN(2, "双列图组件"),
    SLIDE_SHOW(3, "轮播图组件"),
    HORIZONTAL_SLIDING(4, "横向滑动组件"),
    GRAPHIC_NAVIGATION(5, "图文导航组件"),
    TITLE(6, "标题组件"),
    TEXT(7, "文本组件"),
    GOODS(8, "商品组件"),
    GOODS_GROUPS(9, "商品分组组件"),
    ACTIVITY_GROUPS(10, "活动分组组件"),
    POINTS(11, "积分组件"),
    PAGE_SIGN_IN(12, "签到组件"),
    POPUP_SIGN_IN(13, "弹矿签到组件"),
    GUIDES_LINE(14, "辅助线组件"),
    SELF_DEFINING(15, "自定义组件");

    private Integer code;
    private String desc;

    private static List<VisualEditorUnitGroupDto> list = null;

    static {
        list = new ArrayList<>(UnitsGroupEnum.values().length);
        for (UnitsGroupEnum each : UnitsGroupEnum.values()) {
            list.add(new VisualEditorUnitGroupDto(each.getCode(), each.getDesc()));
        }
    }

    UnitsGroupEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static List<VisualEditorUnitGroupDto> getList() {
        return list;
    }
}
