package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.ActivityGroupDto;

import java.util.List;
import java.util.Map;

/**
 * Created by dugq on 2018/8/21.
 */
@AdvancedFeignClient
public interface RemoteActivityGroupService {
    int delete(Long id);

    int insert(ActivityGroupDto record);

    List<ActivityGroupDto> select(ActivityGroupDto pojo, Integer offset, Integer pageSize);

    /**
     * 根据id查找
     * 1.不过滤delete 即被软删除的数据也会返回
     *
     * @param id
     * @return
     */
    ActivityGroupDto selectOne(Long id);

    int update(ActivityGroupDto record);

    int selectCount(ActivityGroupDto pojo);

    Map<Long, List<ActivityGroupDto>> findGroupsByOperationActivityIds(List<Long> ids);

    List<ActivityGroupDto> findGroupsByIds(List<Long> ids);

}
