package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorAppSkinDto;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorSimpleAppSkinDto;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorAppSkinParam;

import java.util.List;

/**
 *
 * @author dugq
 * @date 2018/8/13
 */
@AdvancedFeignClient
public interface RemoteVisualEditorAppSkinService {

    Long insert(VisualEditorAppSkinDto pojo);

    List<VisualEditorAppSkinDto> select(VisualEditorAppSkinParam param);

    /**
     * 根据id查找
     * 1.不过滤delete 即被软删除的数据也会返回
     *
     * @param id
     * @return
     */
    VisualEditorAppSkinDto selectOne(Long id);

    int update(VisualEditorAppSkinDto pojo);

    int delete(Long id);

    /**
     * 根据皮肤id获取皮肤简单信息，包括组件列表 使用了缓存
     * @param skinId 皮肤id
     * @return
     */
    VisualEditorSimpleAppSkinDto selectSimpleAppSkinDtoBySkinIdWithCache(Long skinId);

    /**
     * 根据appId查询商城首页
     * 一个app可以有多个页面，但首页有且只有一个
     * @param appId
     * @return
     */
    VisualEditorAppSkinDto selectIndexPageWithCache(Long appId);
}
