
package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.param.SaasAgentCustomerParam;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuyao on 2016/9/28.
 */
@AdvancedFeignClient
public interface RemoteDeveloperService {
    /**
     * 创建开发者服务
     *
     * @param params     创建开发者提交参数
     * @param needVerify 是否需要进行邮箱验证
     * @return
     */
    DubboResult<Long> createDeveloper(CreateDeveloperParams params, Boolean needVerify);

    /**
     * 查询开发者
     *
     * @param email 开发者账号邮箱
     * @return
     */
    DubboResult<DeveloperDto> findDeveloperByEmail(String email);

    /**
     * 管理端修改邮箱手机号
     *
     * @param id
     * @param email
     * @param phone
     * @return
     */
    DubboResult<Integer> updateEmailAndPhone(Long id, String email, String phone);

    /**
     * 通过ID查询开发者
     *
     * @param id
     * @return
     */
    DubboResult<DeveloperDto> getDeveloperById(Long id);

    /**
     * 更新下次提醒时间
     *
     * @param id
     * @param lastRemindTime
     * @return
     */
    DubboResult<Boolean> updateLastRemindTime(Long id, Date lastRemindTime);

    /**
     * 跟新开发者信息
     *
     * @param developer
     * @return
     */
    DubboResult<Boolean> updateDeveloperInfo(DeveloperDto developer);

    /**
     * 批量查询开发者
     *
     * @param devIds 开发者ids
     * @return
     */
    List<DeveloperDto> findAllByIdList(List<Long> devIds);

    /**
     * 根据email模糊查询
     */
    public List<DeveloperDto> findByEmailLike(String email);

    /**
     * 根据条件查询开发者信息  列表 管理员端使用
     */
    public List<DeveloperDto> findDeveloperPage(Map<String, Object> params);

    /**
     * 根据条件查询开发者信息  列表 管理员端使用
     */
    public Long findDeveloperPageCount(Map<String, Object> params);

    /**
     * 根据参数过滤
     * 1. id in #{developerList} 必填
     * 2. name like #{name} 选填
     * 3. company like #{companyName} 选填
     * 4. 上层加 '%'号
     *
     * @param param
     * @return
     */
    List<DeveloperDto> findAllByParam(SaasAgentCustomerParam param);
}
