package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/8/9 0009 14:57
 */

import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorUnitGroupDto;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 组件类型枚举
 * 1.可视化编辑器使用
 *
 * @author Administrator
 */
public enum UnitsGroupEnum {
    SINGLE_COLUMN(1, "单列图组件"),
    DOUBLE_COLUMN(2, "双列图组件"),
    SLIDE_SHOW(3, "轮播图组件"),
    HORIZONTAL_SLIDING(4, "横向滑动组件"),
    GRAPHIC_NAVIGATION(5, "图文导航组件"),
    TITLE(6, "标题组件"),
    TEXT(7, "文本组件"),
    GOODS(8, "商品组件"),
    GOODS_GROUPS(9, "商品分组组件"),
    ACTIVITY(10, "活动组件"),
    ACTIVITY_GROUPS(11, "活动分组组件"),
    POINTS(12, "积分组件"),
    PAGE_SIGN_IN(13, "页面签到组件"),
    POPUP_SIGN_IN(14, "弹窗签到组件"),
    GUIDES_LINE(15, "辅助线组件"),
    SHOW_WINDOW(16, "橱窗位组件"),
    SELF_DEFINING(17, "自定义组件");

    private Integer code;
    private String desc;

    private static List<VisualEditorUnitGroupDto> list = null;

    static {
        list = new ArrayList<>(UnitsGroupEnum.values().length);
        for (UnitsGroupEnum each : UnitsGroupEnum.values()) {
            list.add(new VisualEditorUnitGroupDto(each.getCode(), each.getDesc()));
        }
    }

    UnitsGroupEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static List<VisualEditorUnitGroupDto> getList() {
        return list;
    }

    /**
     * 根据code返回enum
     *
     * @param code
     * @return
     */
    public static UnitsGroupEnum ofCode(int code) {

        for (UnitsGroupEnum each : UnitsGroupEnum.values()) {
            if (Objects.equals(each.getCode(), code)) {
                return each;
            }
        }
        throw new UnsupportedOperationException("no such UnitsGroupEnum ");
    }
}
