package cn.com.duiba.developer.center.api.utils;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * <p/>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {
    K001("兑吧微信活动web域名"),
    K002("推啊微信活动web域名"),
    k003("APP广告位关系"),
    k004("开发者信用接口"),
    K005("SAAS限流"),
    K006("可视化商城首页"),
    K007("可视化页面及组件列表信息"),
    K008("可视化页面图片库信息"),
    K009("开发者图片库"),
    K010("可视化备份页面及组件列表信息");

    /**
     * 开发者中心:developer-center
     */
    private static final String SPACE = "DC";

    private static final String SEPARATOR = "_";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


    public String join(Object... args){
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
       return key.toString();
    }

    /**
     * 生成唯一的rediskey
     *
     * @param obj 一般是id
     * @return
     */
    public String getKey(Object obj) {
        return new StringBuilder(SPACE).append(SEPARATOR).append(super.toString()).append(SEPARATOR).append(obj).toString();
    }

    private RedisKeyFactory(String description) {

    }

}
