/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.paramquery;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import cn.com.duiba.developer.center.api.utils.ParamEstimateUtils;
import com.google.common.base.Objects;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class WithdrawCashParams
implements Serializable {
    private static final long serialVersionUID = 4184479799430573797L;
    private Long developerId;
    private String cashType;
    private String natureType;
    private String businessLicencePic;
    private String idCardFrontPic;
    private String idCardBackPic;
    private String bank;
    private String bankProvince;
    private String bankCity;
    private String bankBranchName;
    private String bankAccountNumber;
    private String bankAccountName;
    private String alipayAccountNumber;
    private String alipayAccountName;
    private String registerEmail;
    private String phone;
    private String money;
    private Long auditId;
    private String phoneCode;
    private String emailCode;
    private String token;
    private Long appId;
    private Long employeeId;
    private Long incomeMoney;

    public void verify() throws DeveloperCenterException {
        if (StringUtils.isBlank((String)this.cashType)) {
            throw new DeveloperCenterException("\u63d0\u73b0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(Objects.equal((Object)this.cashType, (Object)"alipay") || Objects.equal((Object)this.cashType, (Object)"bank") || Objects.equal((Object)this.cashType, (Object)"remaining"))) {
            throw new DeveloperCenterException("\u63d0\u73b0\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.auditId != null) {
            return;
        }
        if (!(ParamEstimateUtils.isValid(this.bankBranchName) && ParamEstimateUtils.isValid(this.alipayAccountName) && ParamEstimateUtils.isValid(this.bankAccountName))) {
            throw new DeveloperCenterException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if (Objects.equal((Object)this.cashType, (Object)"alipay")) {
            this.validAlipayInfo();
        } else if (Objects.equal((Object)this.cashType, (Object)"bank")) {
            this.validBankInfo();
        }
        this.validCard();
        this.validRemain();
    }

    private void validCard() {
        if (Objects.equal((Object)this.natureType, (Object)"company")) {
            if (StringUtils.isBlank((String)this.businessLicencePic)) {
                throw new DeveloperCenterException("\u4f01\u4e1a\u8425\u4e1a\u6267\u7167\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.idCardFrontPic = null;
            this.idCardBackPic = null;
        } else if (Objects.equal((Object)this.natureType, (Object)"personal")) {
            if (StringUtils.isBlank((String)this.idCardFrontPic)) {
                throw new DeveloperCenterException("\u8eab\u4efd\u8bc1\u6b63\u9762\u7167\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)this.idCardBackPic)) {
                throw new DeveloperCenterException("\u8eab\u4efd\u8bc1\u80cc\u9762\u7167\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.businessLicencePic = null;
        }
    }

    private void validAlipayInfo() {
        if (StringUtils.isBlank((String)this.natureType)) {
            throw new DeveloperCenterException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!Objects.equal((Object)this.natureType, (Object)"company") && !Objects.equal((Object)this.natureType, (Object)"personal")) {
            throw new DeveloperCenterException("\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((String)this.alipayAccountNumber)) {
            throw new DeveloperCenterException("\u652f\u4ed8\u5b9d\u5e10\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.alipayAccountName)) {
            throw new DeveloperCenterException("\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validBankInfo() {
        if (StringUtils.isBlank((String)this.natureType)) {
            throw new DeveloperCenterException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!Objects.equal((Object)this.natureType, (Object)"company") && !Objects.equal((Object)this.natureType, (Object)"personal")) {
            throw new DeveloperCenterException("\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((String)this.bank)) {
            throw new DeveloperCenterException("\u5f00\u6237\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.bankProvince)) {
            throw new DeveloperCenterException("\u5f00\u6237\u884c\u6240\u5728\u7701\u4efd/\u76f4\u8f96\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.bankCity)) {
            throw new DeveloperCenterException("\u5f00\u6237\u884c\u6240\u5728\u57ce\u5e02/\u884c\u653f\u533a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.bankBranchName)) {
            throw new DeveloperCenterException("\u5f00\u6237\u652f\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.bankAccountNumber)) {
            throw new DeveloperCenterException("\u94f6\u884c\u5361\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.bankAccountName)) {
            throw new DeveloperCenterException("\u94f6\u884c\u5361\u5f00\u6237\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validRemain() {
        if (!Objects.equal((Object)this.cashType, (Object)"remaining")) {
            if (!ParamEstimateUtils.isPhone(this.phone)) {
                throw new DeveloperCenterException("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!ParamEstimateUtils.isEmail(this.registerEmail)) {
                throw new DeveloperCenterException("\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isEmpty((String)this.phoneCode)) {
                throw new DeveloperCenterException("\u8bf7\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801");
            }
            if (StringUtils.isEmpty((String)this.emailCode)) {
                throw new DeveloperCenterException("\u8bf7\u83b7\u53d6\u90ae\u7bb1\u9a8c\u8bc1\u7801");
            }
        }
    }

    public Long getDeveloperId() {
        return this.developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getCashType() {
        return this.cashType;
    }

    public void setCashType(String cashType) {
        this.cashType = cashType;
    }

    public String getBusinessLicencePic() {
        return this.businessLicencePic;
    }

    public void setBusinessLicencePic(String businessLicencePic) {
        this.businessLicencePic = businessLicencePic;
    }

    public String getIdCardFrontPic() {
        return this.idCardFrontPic;
    }

    public void setIdCardFrontPic(String idCardFrontPic) {
        this.idCardFrontPic = idCardFrontPic;
    }

    public String getIdCardBackPic() {
        return this.idCardBackPic;
    }

    public void setIdCardBackPic(String idCardBackPic) {
        this.idCardBackPic = idCardBackPic;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankProvince() {
        return this.bankProvince;
    }

    public void setBankProvince(String bankProvince) {
        this.bankProvince = bankProvince;
    }

    public String getBankCity() {
        return this.bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public String getBankBranchName() {
        return this.bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public String getBankAccountName() {
        return this.bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public String getAlipayAccountNumber() {
        return this.alipayAccountNumber;
    }

    public void setAlipayAccountNumber(String alipayAccountNumber) {
        this.alipayAccountNumber = alipayAccountNumber;
    }

    public String getAlipayAccountName() {
        return this.alipayAccountName;
    }

    public void setAlipayAccountName(String alipayAccountName) {
        this.alipayAccountName = alipayAccountName;
    }

    public String getRegisterEmail() {
        return this.registerEmail;
    }

    public void setRegisterEmail(String registerEmail) {
        this.registerEmail = registerEmail;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMoney() {
        return this.money;
    }

    public void setMoney(String money) {
        this.money = money;
    }

    public Long getAuditId() {
        return this.auditId;
    }

    public void setAuditId(Long auditId) {
        this.auditId = auditId;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getEmailCode() {
        return this.emailCode;
    }

    public void setEmailCode(String emailCode) {
        this.emailCode = emailCode;
    }

    public String getNatureType() {
        return this.natureType;
    }

    public void setNatureType(String natureType) {
        this.natureType = natureType;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Long getIncomeMoney() {
        return this.incomeMoney;
    }

    public void setIncomeMoney(Long incomeMoney) {
        this.incomeMoney = incomeMoney;
    }
}

