package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.wolf.utils.SwitchUtils;

/**
 * Created by zhangyongjie on 2021/11/10 2:18 下午
 * 埋点开关状态
 */
public enum AppBuryPointType {

    ALL("0","全部埋点"),
    ONLY_EXPORT("1","仅曝光"),
    ONLY_CLICK("2","仅点击"),
    NONE("3","无埋点");

    private String code;
    private String desc;

    AppBuryPointType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AppBuryPointType getByCode(String code){
        AppBuryPointType[] values = AppBuryPointType.values();
        for(AppBuryPointType appBuryPointType: values){
            if(appBuryPointType.code.equals(code)){
                return appBuryPointType;
            }
        }
        return AppBuryPointType.NONE;
    }

    public static void main(String[] args) {
        Long a = 283742666384L;
        System.out.println(SwitchUtils.switchIsOpen(a,38));
        System.out.println(SwitchUtils.switchIsOpen(a,39));
        Long aLong = SwitchUtils.openSwitch(a, 40);

        long l = aLong << 63 - AppSimpleDto.SwitchBuryPointTwo;
        long switchStatus = l >> 62;
        System.out.println(switchStatus);
    }
}