package cn.com.duiba.developer.center.api.remoteservice.purchase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.purchase.PurchaseFeatureDTO;
import cn.com.duiba.developer.center.api.domain.dto.purchase.PurchaseFeatureDetailDTO;
import cn.com.duiba.developer.center.api.domain.dto.purchase.PurchaseFeatureRecordDTO;

import java.util.List;
import java.util.Map;

/**
 * @Date 2022/4/15 5:11 下午
 * @Created by cmm
 */
@AdvancedFeignClient
public interface RemotePurchaseFeatureRecordService {
    void save(List<PurchaseFeatureRecordDTO> dtos, Long appId);



    /**
     * 查询开发者订购记录
     * @param dto
     * @return
     */
    List<PurchaseFeatureDTO> getTotalByAppId(PurchaseFeatureRecordDTO dto);

    PurchaseFeatureDetailDTO getDetailByVersion(String version,Long appId);

    Map<Long, List<PurchaseFeatureDTO>> getPurchaseListByType(Integer type, Long appId);
}
