package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 充值类型枚举类
 * author zhanghuifeng
 * date 2018-12-20-14:38
 */
public enum RechargeToManualPayTypeEnum {
    EBATONG("ebatong",3, "银行卡"),
    ALIPAY("alipay",1, "支付宝"),
    WXPAY("wxpay",2,"微信"),
    ;
    private String rechargePayTypeCode;

    private Integer manaualPayTypeCode;

    private String desc;

    RechargeToManualPayTypeEnum(String rechargePayTypeCode, Integer manaualPayTypeCode, String desc){
        this.rechargePayTypeCode = rechargePayTypeCode;
        this.manaualPayTypeCode = manaualPayTypeCode;
        this.desc = desc;
    }

    public static Integer getManaualPayTypeCedeByCode(String rechargePayTypeCode){
        if (Objects.isNull(rechargePayTypeCode)){
            return null;
        }
        RechargeToManualPayTypeEnum typeEnum = getByRechargePayTypeCode(rechargePayTypeCode);
        if (Objects.nonNull(typeEnum)){
            return typeEnum.getManaualPayTypeCode();
        }
        return null;
    }

    public static RechargeToManualPayTypeEnum getByRechargePayTypeCode(String rechargePayTypeCode){
        return Arrays.stream(RechargeToManualPayTypeEnum.values()).filter(a -> a.rechargePayTypeCode.equals(rechargePayTypeCode)).findFirst().orElse(null);
    }

    public String getRechargePayTypeCode() {
        return rechargePayTypeCode;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getManaualPayTypeCode() {
        return manaualPayTypeCode;
    }}
