package cn.com.duiba.developer.center.api.domain.dto.floor;

import cn.com.duiba.developer.center.api.domain.enums.ItemListTypeEnum;

import java.io.Serializable;

/**
 * 商品区楼层配置信息
 * Created by xiaoxuda on 2017/5/17.
 */
public class ItemFloorConfigDto implements Serializable{
    private static final long serialVersionUID = 4485650482406746370L;

    /**
     * developDataShowJson数据项的的key,用于标明商品区数据类型
     * 值{@link cn.com.duiba.developer.center.api.domain.enums.ItemListTypeEnum}
     */
    public static final String ITEM_LIST_TYPE = "listPoint";
    /**
     * developDataShowJson数据项的的key,用于标明商品区展示的最大商品数量
     */
    public static final String ITEM_SHOW_NUM = "showNum";
    /**
     * developDataShowJson数据项的的key,用于标明商品区使用的自定义分类ID
     */
    public static final String ITEM_CLASSIFY_ID = "classifyId";

    private ItemListTypeEnum itemListTypeEnum;
    private Integer showNum;
    private Long classifyId;

    public ItemListTypeEnum getItemListTypeEnum() {
        return itemListTypeEnum;
    }

    public void setItemListTypeEnum(ItemListTypeEnum itemListTypeEnum) {
        this.itemListTypeEnum = itemListTypeEnum;
    }

    public Integer getShowNum() {
        return showNum;
    }

    public void setShowNum(Integer showNum) {
        this.showNum = showNum;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }
}
